#ifndef __CV_SUPPORT_H
#define __CV_SUPPORT_H 1

#include <stdint.h>

#include "cv_graphics.h"

extern void cv_init(void); // Initialize Colecovision library.

#if !defined(CV_ASMCALL) 
#if (__SDCC_VERSION_MAJOR > 4 || (__SDCC_VERSION_MAJOR == 4 && (__SDCC_VERSION_MINOR > 1 || __SDCC_VERSION_MINOR == 1 && __SDCC_VERSION_PATCH >= 12)))
#define CV_ASMCALL __sdcccall(0)
#else
#define CV_ASMCALL
#endif
#endif

extern void cv_vdpout(const uint8_t reg, const uint8_t data) CV_ASMCALL __preserves_regs(d, e, iyl, iyh);  // Write data to VDP control register reg.

extern void cv_enable_nmi(void);

extern void cv_disable_nmi(void);

#endif

